<?php
/**
 * Customize Radio Image control class.
 *
 * @package designexo
 *
 * @see     WP_Customize_Control
 * @access  public
 */

/**
 * Class Designexo_Customize_Radio_Image_Control
 */
class Designexo_Customize_Radio_Image_Control extends Designexo_Customize_Base_Control {

	/**
	 * Customize control type.
	 *
	 * @access public
	 * @var    string
	 */
	public $type = 'designexo-radio-image';

	/**
	 * Refresh the parameters passed to the JavaScript via JSON.
	 *
	 * @see    WP_Customize_Control::to_json()
	 * @access public
	 * @return void
	 */
	public function to_json() {

		parent::to_json();

		foreach ( $this->input_attrs as $attr => $value ) {
			if ( 'style' !== $attr ) {
				$this->json['inputAttrs'] .= $attr . '="' . esc_attr( $value ) . '" ';
				continue;
			}
			$this->json['labelStyle'] = 'style="' . esc_attr( $value ) . '" ';
		}

	}

	/**
	 * Renders the Underscore template for this control.
	 *
	 * @see    WP_Customize_Control::print_template()
	 * @access protected
	 * @return void
	 */
	protected function content_template() {
		?>

		<label class="customizer-text">
			<# if ( data.label ) { #><span class="customize-control-title">{{{ data.label }}}</span><# } #>
			<# if ( data.description ) { #><span class="description customize-control-description">{{{ data.description }}}</span><#
			} #>
		</label>
		<div id="input_{{ data.id }}" class="image">
			<# for ( key in data.choices ) { #>
			<# dataAlt = ( _.isObject( data.choices[ key ] ) && ! _.isUndefined( data.choices[ key ].alt ) ) ?
			data.choices[ key ].alt : '' #>
			<input {{{ data.inputAttrs }}} class="image-select" type="radio" value="{{ key }}"
					name="_customize-radio-{{ data.id }}" id="{{ data.id }}{{ key }}" {{{ data.link }}}<# if ( data.value === key ) { #> checked="checked"<# } #> data-alt="{{ dataAlt }}">
			<label for="{{ data.id }}{{ key }}" {{{ data.labelStyle }}} class="{{{ data.id + key }}}">
				<# if ( _.isObject( data.choices[ key ] ) ) { #>
				<img src="{{ data.choices[ key ].src }}" alt="{{ data.choices[ key ].alt }}">
				<span class="image-label"><span class="inner">{{ data.choices[ key ].alt }}</span></span>
				<# } else { #>
				<img src="{{ data.choices[ key ] }}">
				<# } #>
				<span class="image-clickable"></span>
			</label>
			</input>
			<# } #>
		</div>

		<?php
	}

	/**
	 * Render content is still called, so be sure to override it with an empty function in your subclass as well.
	 */
	protected function render_content() {

	}

}
